/*
 * MessageExchangeTransport.java
 *
 * Created on November 16, 2006, 12:13 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.util.soap.EndpointMetaData;
import com.sun.xml.ws.api.message.Message;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.messaging.MessageExchange;

/**
 *
 * Interface to send message to and receive message from NMR.
 *
 * @author bhavani
 */
public interface MessageExchangeTransport {

    public UnWrappedMessage receive(EndpointMetaData emd); // Receive unwrapped message.

    public Exception receiveError();

    public void send(Message abstractMessage, EndpointMetaData emd);

    public void sendStatus(ExchangeStatus status);

    public void sendError(Exception exception);

    /**
     * The following methods are required by the old code path.
     */
    public NormalizedMessage receiveNormalized();

    public void send(NormalizedMessage message);

    public MessageExchange getMessageExchange();
    
    public NormalizedMessage getMessage();
}
