/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.comm;

import com.sun.enterprise.jbi.serviceengine.work.WorkManager;
import com.sun.enterprise.jbi.serviceengine.work.OneWork;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * An instance of this class is used to receive a 
 * reply for a 2-way message exchane from NMR.
 * The object that need to receive the message calls receive()
 * on the instance of this class, after setting MessageExchange.
 * receive() method will block until MessageAcceptor releases it
 * when it receives a reply for the MEP.
 *
 * Typically MessageReceiver.receive() is called on the application
 * thread.
 *
 * @author Binod PG
 */
public class MessageReceiver extends OneWork {

    /**
     * Just calls doWork()
     */
    public void receive() {
        execute();
    }

    /**
     * MessageAcceptor executes this method to notify the waiting
     * thread about the arrival of reply message.
     */
    public void release() {
        synchronized (this) {
            notify();
        }
    }

    /**
     * Register the receiver with MessageAcceptor and waits for
     * the reply/notification.
     */
    public void doWork() {
        MessageAcceptor acceptor = getWorkManager().getMessageAcceptor();
        acceptor.register(this);

        synchronized (this) {
            try {
                wait();
            } catch (InterruptedException ie) {
                setException(ie);
            }
        }
    }

}

