/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.comm;
import com.sun.enterprise.jbi.serviceengine.work.OneWork;
import java.util.logging.Level;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;


/**
 * An instance of this class is used to send a message to 
 * NMR. Messages can be send either using the caller's thread
 * or in a new thread. 
 *
 * @author Binod PG
 * @see OneWork
 */
public class MessageSender extends OneWork {

    /**
     * Users of this class execute send() method to send
     * the message to NMR. Note that execute() method will 
     * finally call doWork().
     */
    public void send() {
        execute();
    }

    /**
     * Actually send the message to NMR.
     */
    public void doWork() {
        try {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST,
                "Sending the message " + getMessageExchange() + "to NMR");
            }
    
            boolean sendSync = shouldSendSync(getMessageExchange());

            if(sendSync) {
                getDeliveryChannel().sendSync(getMessageExchange());
            } else {
                getDeliveryChannel().send(getMessageExchange());
            }
            
            if (getMessageExchange().getStatus()== ExchangeStatus.ERROR) 
                setException(getMessageExchange().getError());
            
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, 
                "Sent message " + getMessageExchange() + "to NMR");
            }
        } catch (MessagingException me) {
            logger.log(Level.WARNING, "Error sending message" + me.getMessage());
            setException(me);
        }
    }
    
    private boolean shouldSendSync(MessageExchange exchange) {

        if(exchange.getRole().equals(MessageExchange.Role.CONSUMER) &&
                exchange.getStatus().equals(ExchangeStatus.ACTIVE)) {
            return true;
        }

        return false;
    }
}
