/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.handlers;

import com.sun.enterprise.Switch;
import com.sun.enterprise.jbi.serviceengine.comm.MessageExchangeTransport;

import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.Transaction;
import javax.transaction.InvalidTransactionException;

/**
 * Transaction handling for JBI message exchanges is done in this class. It has
 * a singleton instance.
 * 
 * @author Vikas Awasthi
 */
public class JBITransactionHandler implements JBIHandler {

    public void handleInbound(MessageExchangeTransport meTransport) throws Exception {
        MessageExchange me = meTransport.getMessageExchange();
        if(!isTxEnabled(me))
            return;

        suspendTx(me);
    }

    public void handleOutbound(MessageExchangeTransport meTransport) throws Exception {
        MessageExchange me = meTransport.getMessageExchange();
        if(!isTxEnabled(me))
            return;

        resumeTx(me);
    }

    protected boolean isTxEnabled(MessageExchange me) {
        return ((tx_enable==null || tx_enable.equalsIgnoreCase("true")) 
                && !isInOnly(me));
    }
    
    private void suspendTx(MessageExchange me) throws SystemException {

        TransactionManager tm = getTM();
        Transaction tx = tm.getTransaction();

        if (tx != null) {
            if(me.getStatus().equals(ExchangeStatus.ERROR))
                tx.setRollbackOnly();
            tx = tm.suspend();
            me.setProperty(MessageExchange.JTA_TRANSACTION_PROPERTY_NAME, tx);
        }
    }

    private void resumeTx(MessageExchange me) throws
            SystemException,
            InvalidTransactionException {

        TransactionManager tm = getTM();
        Transaction tx = (Transaction)me.getProperty(MessageExchange.JTA_TRANSACTION_PROPERTY_NAME);

        if(tx != null) {
            if(me.getStatus().equals(ExchangeStatus.ERROR))
                tx.setRollbackOnly();
            tm.resume(tx);
        }
    }

    private TransactionManager getTM() {
        return Switch.getSwitch().getTransactionManager();
    }
    
    private boolean isInOnly(MessageExchange me) {
        return (me instanceof InOnly);
    }

    private String tx_enable = System.getProperty("com.sun.enterprise.jbi.tx.enable");
}
