/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;


/**
	Provide information about who's listening.
 */
public interface ListenerInfo
{
	/**
		Get the number of listeners which are listening for the
		specified type of Notification.  If there are anonymous listeners (those
		that have no filter or a non-standard filter) then this routine will
		return the value 1.
		
		@param notificationType  any Notification type, should usually be one advertised via MBeanInfo
		@return count of listeners
	 */
	public int	getNotificationTypeListenerCount( final String notificationType );
	
	
	/**
		Get the total number of listeners listening for anything.
		
		@return count of listeners
	 */
	public int	getListenerCount();
}
