/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.management.base;

import java.io.IOException;
import java.io.File;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Utility;
import com.sun.appserv.management.base.Singleton;

/**
	Manages uploading or downloading of files to/from the server. Generally
	for internal use only.
 */
public interface UploadDownloadMgr
	extends AMX, Utility, Singleton
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.UPLOAD_DOWNLOAD_MGR;

	/**
	 	Initiate an upload operation.  The supplied name is intended as
	 	a prefix; if it contains file system separators such as ":", "/" or "\",
	 	they are converted into the "_" character.
	 
	 @param name		name to use for the temp file, may be null
	 @param totalSize	total size of the file to upload
	 @return an opaque identifier describing this file upload
	 */
	public Object initiateUpload(String name, long totalSize )
			throws IOException;

	/**
		Upload bytes for the specified upload
		
	 @param uploadID	the id obtained from initiateUpload()
	 @param bytes		more bytes to be uploaded
	 @return			true if the total upload has been completed, false otherwise
	 @throws			an Exception if a problem occurred
	 */ 
	public boolean uploadBytes(Object uploadID, byte[] bytes)
		throws IOException;
		

	/**
		Ownership of transferred bytes (now in a File) are transferred to
		the caller.
		
		@param uploadID	the id obtained from initiateUpload()
		@return a File object for a file containing the uploaded bytes
		@throws			an Exception if the uploadID doesn't exist, or has not finished.
	 */ 
	public File takeUpload( Object uploadID );



	/**
	 Initiates a file download with the given filename. This operation
	 may be used locally or remotely, but the File specified must exist
	 and be readable on the server.
	 
	 @param theFile	 		an accessible File
	 @param deleteWhenDone	whether to delete the file when done
	 @return the downloadID to be used for subequent calls to downloadBytes()
	 */
	public Object initiateDownload( File theFile, boolean deleteWhenDone )
		throws IOException;
		
	/**
		Get the total length the download will be, in bytes.
		
	 	@param downloadID	the dowloadID, as obtained from initiateDownload()
	 */
	public long getDownloadLength( final Object downloadID );

	/**
		@return the maximum allowable request size for downloading bytes
	 */
	public int	getMaxDownloadChunkSize();

	/**
	 Download bytes from the server using the downloadID obtained from
	 initiateDownload().
	 <p>
	 The bufferSize is the requested number of bytes to 
	 be received. If the size of the returned byte[] is less than
	 the requestSize, then the transfer has completed, and the
	 downloadID is no longer valid.  An attempt to read more than
	 the allowed maximum size will throw an exception.  The caller
	 can check the total download size in advance via
	 getDownloadLength().
	 
	 @param downloadID	the id from initiateDownload()
	 @return bytes remaining bytes, up to the request size
	 */
	public byte[] downloadBytes( Object downloadID, int requestSize )
		throws IOException;



}
