/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client.handler;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.util.Collections;

import java.util.logging.Logger;
import com.sun.appserv.management.base.LoggerSupport;

/**
	Cache which caches anything
 */
class CacheBase<K,V>
{
	private final Map<K,V>		mCache;
	
	/**
	 */
		public
	CacheBase()
	{
		mCache	= Collections.synchronizedMap( new HashMap<K,V>() );
	}
	
	/**
		Cache a proxy using any desired key.
	 */
		public void
	cacheItem(
		final K	key,
		final V	value )
	{
		mCache.put( key, value );
	}
	
		public V
	getCachedItem( K key )
	{
		return( mCache.get( key ) );
	}
	
		public void
	remove( final K key )
	{
		mCache.remove( key );
	}
	
		public Set<K>
	keySet()
	{
		return( mCache.keySet() );
	}
    
    
		public Collection<V>
	values()
	{
		return( mCache.values() );
	}
    
		public void
	clear()
	{
		mCache.clear();
	}
}





