/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client.handler;

import java.io.IOException;

import java.lang.reflect.Method;

import javax.management.ObjectName;


import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ConnectionSource;

/**
    Base class for specialize proxy handlers.
    @see AMXProxyHandlerconvertResult
 */
class ConverterHandler extends AMXProxyHandler
{
        protected
     ConverterHandler(
		final ConnectionSource		connectionSource,
		final ObjectName			proxiedMBeanObjectName )
		throws IOException
     {
        super( connectionSource, proxiedMBeanObjectName );
     }
     
     
    /**
        Optionally, transform any arguments.  The number of arguments must
        not be changed, and the original array must not be modified.
     */
        protected Object[]
    convertArgs(
		final Object		myProxy,
    	final Method		method,
		final Object[]		argsIn  )
    {
        return argsIn;    // no change
    }
    
    /**
        Optionally, transform any result.
     */
        protected Object
    convertResult(
        final Method method,
        final Object resultIn )
    {
        return resultIn;    // no change
    }
    
		protected final Object
	_invoke(
		final Object		myProxy,
    	final Method		method,
		final Object[]		argsIn )
   		throws java.lang.Throwable
   	{
   	    final Object[]  args    = convertArgs( myProxy, method, argsIn );
   	    
   	    final Object temp = super._invoke( myProxy, method, args );
   	    
   	    final Object result = (temp == null) ? null : convertResult( method, temp );
   	    
   	    if ( result != temp && temp != null )
   	    {
//   	    System.out.println( "Convert occured from class " + temp.getClass().getName() +
//   	        " to " + result.getClass().getName() );
   	    }
   	    
   		return( result );
   	}
   
}





