/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client.handler;

import java.lang.reflect.Method;

import java.io.Serializable;
import java.io.IOException;

import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.client.ConnectionSource;

import com.sun.appserv.management.util.misc.TypeCast;

import com.sun.appserv.management.ext.wsmgmt.WebServiceSupport;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;


/**
    Specialized handler for {@link com.sun.appserv.management.ext.logging.Logging}.
 */
final class WebServiceMgrConverterHandler extends ConverterHandler
{
		public
	WebServiceMgrConverterHandler(
		final ConnectionSource		connectionSource,
		final ObjectName			proxiedMBeanObjectName )
		throws IOException
	{
		super( connectionSource, proxiedMBeanObjectName );
	}
    
    /**
        Optionally, transform any result.
     */
        protected Object
    convertResult(
        final Method method,
        final Object resultIn )
    {
        Object  resultOut   = resultIn;
        
        if ( method.getName().equals( "getWebServiceEndpointInfo" ) )
        {
            final Map<String,Serializable>  m  = TypeCast.asMap( resultIn );
            
            final WebServiceEndpointInfo info =
                WebServiceSupport.mapToWebServiceEndpointInfo( m );
            resultOut   = info;
        }
        
        return resultOut;
    }
}





