/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/ClusterRefConfig.java,v 1.1 2006/12/02 06:03:00 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:00 $
 */

package com.sun.appserv.management.config;


import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;

/**
 * represents the &lt;server-ref&gt; element.
 */
public interface ClusterRefConfig extends RefConfig, HealthCheckerConfigCR, Container {

    /** 
      The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. 
     */
    public static final String	J2EE_TYPE	= XTypes.CLUSTER_REF_CONFIG;

    /**
        @since Appserver 9.0
     */
    public String   getReferencedClusterName();
    
    /**
        @since Appserver 9.0
     */
    public void   setReferencedClusterName( String clusterName );
    
    
    /**
      <b>EE only</b>                                                
        Load balancing policy to be used for this cluster. Possible   
        values are round-robin , weighted-round-robin or              
        user-defined. round-robin is the default. For                 
        weighted-round-robin, the weights of the instance are         
        considered while load balancing. For user-defined, the policy 
        is implemented by a shared library which is loaded by the     
        load balancer and the instance selected is delegated to the   
        loaded module.               
        
      Return load balancing policy to be used for this cluster. Possible
      values are: See {@link LbPolicyTypeValues}. 
     */
    public String getLBPolicy();

    /**
       <b>EE only</b>
       Set the load balancing policy to be used for this cluster. 
       See {@link com.sun.appserv.management.config.LbPolicyTypeValues}.
     */
    public void setLBPolicy(final String value);

    /**
      <b>EE only</b>
      Returns the absolute path to the shared library
      implementing the {@link LbPolicyTypeValues#USER_DEFINED} policy. 
     */
    public String getLBPolicyModule();

    /**
      <b>EE only</b>
      Sets the absolute path to the shared library implementing the 
      {@link LbPolicyTypeValues#USER_DEFINED} policy. 
     */
    public void setLBPolicyModule(final String lbPolicyModule);        
}
