/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

/**
	Optional keys for use with any create() method.  Note that keys defined here
	may or may not apply to a particular create method.
	<p>
	<b>NOTE: in Appserver 9.0, all key values are of type java.lang.String</b>
 */
public class CommonConfigKeys
{
	protected	CommonConfigKeys()	{}
	
	/*
		NOTE: if you add any meta options here, such as 'IGNORE_MISSING_REFERENCES',
		you may need to make sure they don't get passed along to underlying old
		MBeans.  See ConfigFactory.initParams().
	 */
	
	/**
		Key for use with any create method which indicates that missing references are to be
		ignored.  If not specified, all references must be to items that exist.
		Value must be java.lang.Boolean.
	*/
	public static final String	IGNORE_MISSING_REFERENCES_KEY		= "IgnoreMissingReferences";
}
