/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/EJBContainerConfig.java,v 1.1 2006/12/02 06:03:05 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:05 $
 */


package com.sun.appserv.management.config;

import java.util.Map;



import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;



/**
	 Configuration for the &lt;ejb-container&gt; element.
 */
public interface EJBContainerConfig extends 
	AMXConfig, Container, PropertiesAccess
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.EJB_CONTAINER_CONFIG;

	String	getCacheIdleTimeoutInSeconds();
	void	setCacheIdleTimeoutInSeconds( final String value );

	String	getCacheResizeQuantity();
	void	setCacheResizeQuantity( final String value );

	String	getCommitOption();
	void	setCommitOption( final String value );

	String	getMaxCacheSize();
	void	setMaxCacheSize( final String value );

	String	getMaxPoolSize();
	void	setMaxPoolSize( final String value );

	String	getPoolIdleTimeoutInSeconds();
	void	setPoolIdleTimeoutInSeconds( final String value );

	String	getPoolResizeQuantity();
	void	setPoolResizeQuantity( final String value );

	String	getRemovalTimeoutInSeconds();
	void	setRemovalTimeoutInSeconds( final String value );

	String	getSessionStore();
	void	setSessionStore( final String value );

	String	getSteadyPoolSize();
	void	setSteadyPoolSize( final String value );

	String	getVictimSelectionPolicy();
	void	setVictimSelectionPolicy( final String value );

	/**
		Creates ejb-timer-service element. Legal options include:
		<ul>
		<li>{@link EJBTimerServiceConfigKeys#MINIMUM_DELIVERY_INTERVAL_IN_MILLIS_KEY}</li>
		<li>{@link EJBTimerServiceConfigKeys#MAX_REDELIVERIES_KEY}</li>
		<li>{@link EJBTimerServiceConfigKeys#TIMER_DATASOURCE_KEY}</li>
		<li>{@link EJBTimerServiceConfigKeys#REDELIVERY_INTERVAL__INTERNAL_IN_MILLIS_KEY}</li>
		</ul>

		@param params
		@return A proxy to the EJBTimerServiceConfig MBean.
		@see EJBTimerServiceConfigKeys#REDELIVERY_INTERVAL__INTERNAL_IN_MILLIS_KEY
	 */
	EJBTimerServiceConfig	createEJBTimerServiceConfig( Map<String,String> params );

	/**
		Removes ejb-timer-service element from config
	 */
	void		removeEJBTimerServiceConfig();


	/**
		@return Get the EJBTimerServiceConfig MBean.
	 */
	EJBTimerServiceConfig	getEJBTimerServiceConfig();
}
