/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/HTTPFileCacheConfigKeys.java,v 1.1 2006/12/02 06:03:07 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:07 $
 */
package com.sun.appserv.management.config;


/**
	Keys for use with {@link HTTPServiceConfig#createHTTPFileCacheConfig}
	
	All Map values associated with a key are of class java.lang.String
	unless otherwise documented.
 */
public final class HTTPFileCacheConfigKeys
{
	private	HTTPFileCacheConfigKeys()	{}
	public static final String GLOBALLY_ENABLED_KEY				=	"GloballyEnabled";
	public static final String FILE_CACHING_ENABLED_KEY			=	"FileCachingEnabled";
	public static final String MAX_AGE_IN_SECONDS_KEY			=	"MaxAgeInSeconds";
	public static final String MEDIUM_FILE_SIZE_LIMIT_IN_BYTES_KEY	=	"MediumFileSizeLimitInBytes";
	public static final String MEDIUM_FILE_SPACE_IN_BYTES_KEY		=	"MediumFileSpaceInBytes";
	public static final String SMALL_FILE_SIZE_LIMIT_IN_BYTES_KEY	=	"SmallFileSizeLimitInBytes";
	public static final String SMALL_FILE_SPACE_IN_BYTES_KEY		=	"SmallFileSpaceInBytes";
	public static final String FILE_TRANSMISSION_ENABLED_KEY		=	"FileTransmissionEnabled";
	public static final String MAX_FILES_COUNT_KEY					=	"MaxFilesCount";
	public static final String HASH_INIT_SIZE_KEY					=	"HashInitSize";
}