/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

/**
	Keys for use with {@link HTTPServiceConfig#createHTTPListenerConfig}.
 */
public final class HTTPListenerConfigKeys extends CommonConfigKeys
{
	private	HTTPListenerConfigKeys()	{}
	
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	ADDRESS_KEY				= "Address";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	PORT_KEY				= "Port";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	ENABLED_KEY				= "Enabled";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	SECURITY_ENABLED_KEY	= "SecurityEnabled";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	DEFAULT_VIRTUAL_SERVER_KEY	= "DefaultVirtualServer";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	ACCEPTOR_THREADS_KEY	= "AcceptorThreads";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() (Boolean) */
	public final static String	XPOWERED_BY_KEY			= "XpoweredBy";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	SERVER_NAME_KEY			= "ServerName";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	EXTERNAL_PORT_KEY		= "ExternalPort";
	/**
		Key for use with HTTPServiceConfig#createHTTPListenerConfig()
		Legal values are as defined in {@link HTTPListenerConfigFamilyValues}.
	 */
	public final static String	FAMILY_KEY				= "Family";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	BLOCKING_ENABLED_KEY	= "BlockingEnabled";
	/** Key for use with HTTPServiceConfig#createHTTPListenerConfig() */
	public final static String	REDIRECT_PORT_KEY		= "RedirectPort";
	
	/**
		Key for use with HTTPServiceConfig#createHTTPListenerConfig()
		Value should be a Map containing items keyed by keys in {@link SSLConfigKeys}
	*/
	public final static String	SSL_PARAMS_KEY			= "SSL";
}
