/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/IIOPServiceConfig.java,v 1.1 2006/12/02 06:03:09 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:09 $
 */


package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;






/**
	 Configuration for the &lt;iiop-service&gt; element.
 */
public interface IIOPServiceConfig
	extends ConfigElement, Container
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.IIOP_SERVICE_CONFIG;

	/**
		Creates ssl-client-config element.

		@param params
		@return Returns a proxy to the SSLConfig MBean.
	 */
	public SSLConfig	createIIOPSSLClientConfig( Map<String,String> params );

	/**
		Removes ssl-client-config element.
	 */
	public void			removeIIOPSSLClientConfig();

	/**
		Get the SSLConfig MBean that corresponds to ssl-client-config
		element of this iiop service.
	 */
	public SSLConfig	getIIOPSSLClientConfig();

	public boolean		getClientAuthenticationRequired();

	public void		setClientAuthenticationRequired( final boolean value );



	/**
		Calls Container.getContaineeMap( XTypes.IIOP_LISTENER_CONFIG ).
		@return Map of IIOPListenerConfig MBean proxies, keyed by name.
		@see com.sun.appserv.management.base.Container#getContaineeMap
	 */
	public Map<String,IIOPListenerConfig>		getIIOPListenerConfigMap();
	
	
	/**
		Create an <iiop-listener>. Most fields will default to reasonable values.
		Caller should modify them after creation, if desired.
		
		@param name 	the name (id) of the newly created listener
		@param address	IP address of the listener
		@param optional	optional parameters
		@see IIOPListenerConfigKeys
	 */
	public IIOPListenerConfig	createIIOPListenerConfig( String name, String address, Map<String,String> optional );

	/**
		Removes an iiop listener.

		@param name the name (id) of the iiop listener to be removed.
	 */
	public void			removeIIOPListenerConfig( String name );


	/**
		Get a proxy to an ORBConfig
	 */
	ORBConfig					getORBConfig();
}







