/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;


import java.util.logging.Level;

/**
	Legal log levels.  These are identical to those specified by by JDK 1.5;
	see {@link Level}, which should be used in preference to this class.
	
	@see ModuleLogLevelsConfig
 */
public final class LogLevelValues
{
	private LogLevelValues()	{}
	
	public static final String		FINEST	= "FINEST";
	public static final String		FINER	= "FINER";
	public static final String		FINE	= "FINE";
	public static final String		CONFIG	= "CONFIG";
	public static final String		INFO	= "INFO";
	public static final String		WARNING	= "WARNING";
	public static final String		SEVERE	= "SEVERE";
	public static final String		OFF		= "OFF";
	
}
