/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/PropertiesAccess.java,v 1.1 2006/12/02 06:03:19 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:19 $
 */

package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;


import java.util.Map;



/**
	All MBeans that have Properties must extend this interface.
	<p>
	Properties are always Strings.  Property names are required to be unique.
	<p>
	To specify properties when creating any type of {@link AMXConfig} which
	(the AMXConfig must extend PropertiesAccess), add them to the optional
	Map when creating it:
<pre><code>
    final Map<String,String> optional    = new HashMap<String,String>();
    optional.put( PropertiesAccess.PROPERTY_PREFIX + "prop1", prop1Value );
    optional.put( PropertiesAccess.PROPERTY_PREFIX + "prop2", prop2Value );
    ...
</code></pref> 
 */
public interface PropertiesAccess
{
	/**
		When a key is required for a property in a Map,
		its name must consist of this prefix plus the actual name.  When
		accessing a property directly, this prefix must not be used.
	 */
    final static String PROPERTY_PREFIX = "property.";
    
	/**
		Get the names of all properties.
	 */
	public String[]	getPropertyNames( );
	
	/**
		@return Map containing all properties, keyed by name
	 */
	public Map<String,String>	getProperties();
	
	/**
		Get the value of a property.
		
		@param propertyName	the name of the property
	 */
	public String	getPropertyValue( String propertyName );
					
	/**
		Set the value of a property.  The property must already exist.
		The existing description is retained.
		
		@param propertyName	the name of the property
		@param propertyValue	the value of the property
	 */	
	public void		setPropertyValue( String propertyName, String propertyValue );
						
	/**
		Return true if any properties exist with the specified name.
		
		@param propertyName	the name of the property
	 */
	public boolean	existsProperty( String propertyName );
	
	/**
		Create a new property.
		
		@param propertyName		the name of the property
		@param propertyValue	the value of the property
	 */
	public void		createProperty( String propertyName, String propertyValue);
	
	/**
		Remove a property with the specified name. 
		
		@param propertyName	the name of the property
	 */
	public void		removeProperty( String propertyName );
}


