/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/TemplateResolver.java,v 1.1 2006/12/02 06:03:25 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:25 $
 */
package com.sun.appserv.management.config;


/**
	Interface implemented by MBeans which can resolve a template
	String to a value.  Template strings are of the form ${XYZ} and
	are returned as the values of certain Attributes.
 */
public interface TemplateResolver
{
	/**
		If the String is a template, return true.  A template String is a String
		of the form ${XYZ}.
		
		@param s
		@return true if the String is template String, false otherwise.
	 */
	public boolean	isTemplateString( String s );
	
	/**
		If the String is a template, resolve it. If it is a template, but
		cannot be resolved, return it unchanged.
		<p>
		If the String is not a template, return it unchanged.
		
		@param template	a template String
		@return resolved value
	 */
	public String	resolveTemplateString( String template );
}



