/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/TransactionServiceConfig.java,v 1.1 2006/12/02 06:03:26 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:26 $
 */

package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;


/**
	 Configuration for the &lt;transaction-service&gt; element.
*/

public interface TransactionServiceConfig extends ConfigElement, PropertiesAccess
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.TRANSACTION_SERVICE_CONFIG;

	public boolean	getAutomaticRecovery();
	public void	setAutomaticRecovery( boolean value );

	public String	getHeuristicDecision();
	public void	setHeuristicDecision( String value );

	public String	getKeypointInterval();
	public void	setKeypointInterval( String value );

	public String	getRetryTimeoutInSeconds();
	public void	setRetryTimeoutInSeconds( String value );

	public String	getTimeoutInSeconds();
	public void	setTimeoutInSeconds( String value );

	public String	getTxLogDir();
	public void	setTxLogDir( String value );





}
