/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/WebContainerAvailabilityConfigKeys.java,v 1.1 2006/12/02 06:03:27 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:27 $
 */


package com.sun.appserv.management.config;


/**
	Parameters used by {@link AvailabilityServiceConfig} 
	when creating a new &lt;web-container-availability> element.
	
	@see AvailabilityServiceConfig
 */
public final class WebContainerAvailabilityConfigKeys
{
	private WebContainerAvailabilityConfigKeys()	{}
	
	public static final String WEB_CONTAINER_AVAILABILITY_ENABLED_KEY	= "AvailabilityEnabled";

	/**
		See {@link PersistenceTypeValues}.
	 */
	public static final String PERSISTENCE_TYPE_KEY					= "PersistenceType";

	/**
		See {@link SessionSaveFrequencyValues}.
	 */
	public static final String PERSISTENCE_FREQUENCY_KEY				= "PersistenceFrequency";

	/**
		See {@link SessionSaveScopeValues}.
	 */
	public static final String PERSISTENCE_SCOPE_KEY					= "PersistenceScope";

	public static final String PERSISTENCE_STORE_HEALTH_CHECK_ENABLED_KEY = "PersistenceStoreHealthCheckEnabled";

	public static final String SSO_FAILOVER_ENABLED_KEY				= "SSOFailoverEnabled";

	public static final String HTTP_SESSION_STORE_POOL_NAME_KEY		= "HTTPSessionStorePoolName";
}

