/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/config/WebModuleConfig.java,v 1.1 2006/12/02 06:03:28 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:28 $
 */

package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;

/**
	 Configuration for the &lt;web-module&gt; element.
*/

public interface WebModuleConfig
    extends ModuleConfig, Libraries, Container, WebServiceEndpointConfigCR
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.WEB_MODULE_CONFIG;
	
	/**
	The ContextRoot must match the pattern for the hpath production  
	in RFC 1738 which can be found at:                            
	http://www.w3.org/Addressing/rfc1738.txt. This is flattened   
	to the following regular expression in XML Schema's pattern   
	language:

	<pre>                                     
	([a-zA-Z0-9$\-_.+!*'(),]|%[0-9A-Fa-f][0-9A-Fa-f]|;|:|&|=)*(/([
	-zA-Z0-9$\-_.+!*'(),]|%[0-9A-Fa-f][0-9A-Fa-f]|;|:|&|=)*)*
	</pre>
	  
	Note that this includes the null or empty context root and    
	permits but does not require a context root to start with the 
	'/' character (including a context root which is simply the   
	'/' character).
	@see #setContextRoot                                       
	*/
      
	public String	getContextRoot();
	
	/**
	@see #getContextRoot                                       
	*/
	public void		setContextRoot( String value );

	/**
		Controls whether availability is enabled    
		for HTTP Session Persistence. If this is "false", then all    
		session persistence is disabled for the given web module. If  
		it is "true" (and providing that all the availability-enabled 
		attributes above in precedence are also "true", then the web  
		module may be ha enabled. Finer-grained control exists at     
		lower level (see sun-web.xml).                               

		@see #setAvailabilityEnabled
	 */
	public boolean	getAvailabilityEnabled();

	/**
		@see #getAvailabilityEnabled
	*/       
	public void		setAvailabilityEnabled( boolean enabled );
	
    public Map<String,WebServiceEndpointConfig> getWebServiceEndpointConfigMap();
}
