/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/ext/update/UpdateStatus.java,v 1.1 2006/12/18 22:41:48 sv96363 Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/18 22:41:48 $
 */

package com.sun.appserv.management.ext.update;


import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Singleton;
import com.sun.appserv.management.base.Utility;

/**
	Provides information about the updates from the Update Center Server.
 */
public interface UpdateStatus extends AMX, Singleton, Utility 
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.UPDATE_STATUS;
	

	/**
		Return the number of available updated modules. These modules could be 
        can be addon component installer or configurator jar file as specified 
        in Addon installer and configurator plug-in which can perform an update.
        Alternatively, these also can be jar or zip archive containing 
        component files archived relative to Glassfish
        main installation directory. For example, they could be non-runtime
        components such as documentation, tutorials, sample applications
        packaged as zip or jar archive files. 
		
		@return return the number of available updated modules
	 */
	public int	getNumModules();

}
