/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/helper/NotificationServiceHelper.java,v 1.1 2006/12/02 06:03:36 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:36 $
 */
package com.sun.appserv.management.helper;

import java.util.Map;

import javax.management.Notification;

import com.sun.appserv.management.base.NotificationService;

/**
	Helps make it easier to get Notifications from a NotificationService
 */
public final class NotificationServiceHelper
{
	final NotificationService	mProxy;
	final Object					mBufferID;
	long							mNextSequenceNumber;
	
		public
	NotificationServiceHelper(
		final NotificationService	proxy,
		final Object					bufferID )
	{
		mProxy				= proxy;
		mBufferID			= bufferID;
		
		mNextSequenceNumber	= 0;
	}
	
	
		public NotificationService
	get()
	{
		return( mProxy );
	}
	
	/**
		Get any outstanding Notifications and return them.
	 */
		public Notification[]
	getNotifications()
	{
		final Map<String,Object>	result	=
			mProxy.getBufferNotifications( mBufferID, mNextSequenceNumber);
		
		final Long	nextSequenceNumber	= (Long)
			result.get( mProxy.NEXT_SEQUENCE_NUMBER_KEY );
		mNextSequenceNumber	= nextSequenceNumber.longValue();
		
		final Notification[]	notifs	=
			(Notification[])result.get( mProxy.NOTIFICATIONS_KEY );
		
		return( notifs );
	}
}


