/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/j2ee/J2EEDomain.java,v 1.1 2006/12/02 06:03:39 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:39 $
 */
 
package com.sun.appserv.management.j2ee;

import java.util.Map;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;

/**
	The discovery and navigation of all managed objects in the J2EE
	management system begins with the J2EEDomain.

	@see J2EEServer
	@see J2EECluster
	@see J2EEApplication
	@see JVM
	@see AppClientModule
	@see EJBModule
	@see WebModule
	@see ResourceAdapterModule
	@see EntityBean
	@see StatefulSessionBean
	@see StatelessSessionBean
	@see MessageDrivenBean
	@see Servlet
	@see JavaMailResource
	@see JCAResource
	@see JCAConnectionFactory
	@see JCAManagedConnectionFactory
	@see JDBCResource
	@see JDBCDataSource
	@see JDBCDriver
	@see JMSResource
	@see JNDIResource
	@see JTAResource
	@see RMIIIOPResource
	@see URLResource
 */
public interface J2EEDomain
	extends J2EEManagedObject,ConfigProvider, Container
{
	public final static String		J2EE_TYPE	= J2EETypes.J2EE_DOMAIN;
	
	/**
		Note that the Attribute name is case-sensitive
		"servers" as defined by JSR 77.
		
		@return the ObjectNames of the J2EEServers, as Strings
	 */
	public String[]	getservers();

    /**
        @return the full version string, including the build number
     */
    public String getFullVersion();

	/**
		@return a Map keyed by server name of J2EEServer
		@deprecated used {@link #getJ2EEServerMap}
	 */
	public Map<String,J2EEServer>		getServerMap();
	

	/**
		@return a Map keyed by server name of J2EEServer
	 */
	public Map<String,J2EEServer>		getJ2EEServerMap();
	
	/**
		@return the ObjectNames of the J2EEClusters, as Strings
		@deprecated use {@link #getJ2EEClusterMap}
	 */
	public String[]	getclusters();
	
	 /**
       @return a Map keyed by cluster name of J2EECluster
	   @deprecated use {@link #getJ2EEClusterMap}
    */
   public Map<String,J2EECluster>        getClusterMap(); 
   
	 /**
       @return a Map keyed by cluster name of J2EECluster
    */
   public Map<String,J2EECluster>        getJ2EEClusterMap(); 
}









