/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/j2ee/J2EEManagementEvent.java,v 1.1 2006/12/02 06:03:39 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:39 $
 */
 
package com.sun.appserv.management.j2ee;



/**
 */
public interface J2EEManagementEvent
{
	/**
		The name of the managed object that generated this event.
		
 		@return the ObjectName of the object, as a String
	 */
	public String	getSource();
	
	/**
		The time of the event represented as a long, whose value is
		the number of milliseconds since January 1, 1970, 00:00:00.
	 */
	public long			getWhen();
	
	/**
		The sequence number of the event.
		Identifies the position of the event in a stream
		of events. The sequence number provides a means of
		determining the order of sequential events that
		occurred with the same timestamp (within the
		minimum supported unit of time).
	 */
	public long			getSequence();
	
	/**
		The type of the event. State manageable objects generate a
		J2EEEvent object with the type attribute set to "STATE"
		whenever they reach the RUNNING, STOPPED or FAILED states.
	 */
	public String		getType();
	
	/**
		An informational message about the event.
	 */
	public String		getMessage();
}
