/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.j2ee;

import java.util.Map;
import java.util.Set;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Container;


/**
 */
public interface J2EEServer extends J2EELogicalServer, Container
{
	public final static String		J2EE_TYPE	= J2EETypes.J2EE_SERVER;
	
	/**
	    Restart the server.
	    <b>Enterprise Edition only.</b>
	 */
	public void restart();
	
	/**
		Note that the Attribute name is case-sensitive
		"deployedObjects" as defined by JSR 77.
		
	 	@return the ObjectNames as Strings
	 */
	public String[]	getdeployedObjects();
	
	/**
		Return Set of all deployed objects.  Possible types include:
		<ul>
		<li>{@link com.sun.appserv.management.j2ee.J2EEApplication}</li>
		<li>{@link com.sun.appserv.management.j2ee.WebModule}</li>
		<li>{@link com.sun.appserv.management.j2ee.EJBModule}</li>
		<li>{@link com.sun.appserv.management.j2ee.AppClientModule}</li>
		<li>{@link com.sun.appserv.management.j2ee.ResourceAdapterModule}</li>
		</ul>
		<p>
		To obtain Resources of a particular type, use
		{@link Container#getContaineeMap}(j2eeType).
	 */
	public Set<J2EEDeployedObject>	getDeployedObjectsSet();
	
	/**
		In 8.1, there will only ever be one JVM for a J2EEServer.
		Note that the Attribute name is case-sensitive
		"javaVMs" as defined by JSR 77.
		
	 	@return the ObjectNames as Strings
	 */
	public String[]	getjavaVMs();
	
	/**
		There is always a single JVM for a J2EEServer.
		@return JVM
	 */
	public JVM		getJVM();
	
	/**
		Note that the Attribute name is case-sensitive
		"resources" as defined by JSR 77.
		
	 	@return the ObjectNames as Strings
	 */
	public String[]		getresources();
	
	/**
		Return Set of all resources.  Possible types include:
		<ul>
		<li>{@link com.sun.appserv.management.j2ee.JDBCResource}</li>
		<li>{@link com.sun.appserv.management.j2ee.JavaMailResource}</li>
		<li>{@link com.sun.appserv.management.j2ee.JCAResource}</li>
		<li>{@link com.sun.appserv.management.j2ee.JMSResource}</li>
		<li>{@link com.sun.appserv.management.j2ee.JNDIResource}</li>
		<li>{@link com.sun.appserv.management.j2ee.JTAResource}</li>
		<li>{@link com.sun.appserv.management.j2ee.RMIIIOPResource}</li>
		<li>{@link com.sun.appserv.management.j2ee.URLResource}</li>
		</ul>
		<p>
		To obtain Resources of a particular type, use
		{@link Container#getContaineeMap}(j2eeType).
	 */
	public Set<J2EEResource> getResourcesSet();
	
	/**
		Note that the Attribute name is case-sensitive
		"serverVendor" as defined by JSR 77.
		
	 	@return the server vendor, a free-form String
	 */
	public String		getserverVendor();
	
	/**
		Note that the Attribute name is case-sensitive
		"serverVersion" as defined by JSR 77.
		
	 	@return the server version, a free-form String
	 */
	public String		getserverVersion();
	
	/**
	 	@return the full server version,including the build number
        @since AppServer 9.1
	 */
    public String getFullServerVersion();

	/**
	 	@return true if server configuration has changed such that a restart must
	 	be performed.
	 */
    public boolean  getRestartRequired();
}



