/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.appserv.management.j2ee.statistics;

import java.util.Map;
import java.io.Serializable;

import javax.management.openmbean.CompositeData;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;

import com.sun.appserv.management.j2ee.statistics.StatisticImpl;

/**
 *
 */
public final class NumberStatisticImpl
        extends StatisticImpl implements NumberStatistic, Serializable {
    static final long serialVersionUID = 2090185734375468533L;
    
    private Number Current;
    
    public NumberStatisticImpl( final CompositeData compositeData ) {
        this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
    }
    
    public NumberStatisticImpl( final Map<String,?> m ) {
        this( new MapStatisticImpl( m ) );
    }
    
    public NumberStatisticImpl( final NumberStatistic n ) {
        super( n );        
        Current = n.getCurrent();
    }
    
    public NumberStatisticImpl( final MapStatistic m ) {
        super( m );        
        Current = (Number)m.getValue( "Current" );
    }
    
    public NumberStatisticImpl(
            final String	name,
            final String	description,
            final String	unit,
            final long		startTime,
            final long		lastSampleTime,
            final Number	current ) {
        super( name, description, unit, startTime, lastSampleTime );
        this.Current = current;
    }
    
    public void setNumber(Number c) {
          this.Current = c;
          this.mLastSampleTime = System.currentTimeMillis();
    } 

    public Number getCurrent() {
        return( Current );
    }
}





