/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/j2ee/statistics/RangeStatisticImpl.java,v 1.1 2006/12/02 06:03:47 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:03:47 $
 */

package com.sun.appserv.management.j2ee.statistics;

import java.util.Set;
import java.util.Map;
import java.io.Serializable;

import javax.management.openmbean.CompositeData;

import javax.management.j2ee.statistics.Statistic;
import javax.management.j2ee.statistics.RangeStatistic;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;

/**
	
 */
public class RangeStatisticImpl extends StatisticImpl
	implements RangeStatistic, Serializable
{
	static final long serialVersionUID = 6530146323113291603L;
	
	/* member names as defined by JSR 77 */
	private final long	Current;
	private final long	HighWaterMark;
	private final long	LowWaterMark;
	
	
		public
	RangeStatisticImpl(
		final String	name,
		final String	description,
		final String	unit,
		final long		startTime,
		final long		lastSampleTime,
		final long		low,
		final long		current,
		final long		high )
	{
		super( name, description, unit, startTime, lastSampleTime );
		
		if ( current < low || current > high )
		{
			throw new IllegalArgumentException();
		}
		
		Current	= current;
		HighWaterMark	= high;
		LowWaterMark	= low;
	}
	
		public
	RangeStatisticImpl( final CompositeData compositeData )
	{
		this( OpenMBeanUtil.compositeDataToMap( compositeData ) );
	}
	
		public
	RangeStatisticImpl( final Map<String,?> m )
	{
		this( new MapStatisticImpl( m ) );
	}
	
		public
	RangeStatisticImpl( final RangeStatistic s )
	{
		super( s );
		
		Current			= s.getCurrent();
		LowWaterMark	= s.getHighWaterMark();
		HighWaterMark	= s.getLowWaterMark();
	}
	
	
		public
	RangeStatisticImpl( final MapStatistic s )
	{
		super( s );
		
		Current			= s.getlong( "Current" );
		LowWaterMark	= s.getlong( "LowWaterMark" );
		HighWaterMark	= s.getlong( "HighWaterMark" );
	}


 		public long
 	getCurrent()
 	{
 		return( Current );
 	}

 		public long
 	getHighWaterMark()
 	{
 		return( HighWaterMark );
 	}

 		public long
 	getLowWaterMark()
 	{
 		return( LowWaterMark );
 	}
}





