/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 */

package com.sun.appserv.management.monitor;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Container;


/**
	Interface for Monitor of J2EEApplication.
 */
public interface ApplicationMonitor extends Container, Monitoring {
    
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.APPLICATION_MONITOR;
    
    
    /**
		@return a Map of EJBModuleMonitor belonging to this application, keyed by name.
     */
	public Map<String,EJBModuleMonitor>		getEJBModuleMonitorMap();
	
    /**
		@return a Map of {@link WebModuleVirtualServerMonitor}
			belonging to this application, keyed by name.
     */
	public Map<String,WebModuleVirtualServerMonitor>		getWebModuleVirtualServerMonitorMap();
}
