/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: KeepAliveStats.java,v 1.1 2006/12/02 06:03:59 llc Exp $
 * $Date: 2006/12/02 06:03:59 $
 * $Revision: 1.1 $
 */

package com.sun.appserv.management.monitor.statistics;

import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;

/**
	@see com.sun.appserv.management.monitor.KeepAliveMonitor
 */
public interface KeepAliveStats extends Stats
{
    /** 
     * @return number of keep-alive connections that timed out.
     */    
	public CountStatistic	getCountTimeouts();
	
    /** 
        @return number of connections in keep-alive mode
     */    
	public CountStatistic	getCountConnections();
	
    /** 
        Gets the number of seconds before a keep-alive connection that has
        been idle times out and is closed.
     
        @return Keep-alive timeout in number of seconds
     */    
	public CountStatistic	getSecondsTimeouts();
	
    /** 
        @return maximum number of concurrent connections in keep-alive mode
     */    
	public CountStatistic	getMaxConnections();
	

    /** 
        @return number of keep-alive connections that were rejected.
     */    
	public CountStatistic	getCountRefusals();
	
    /** 
        @return Number of keep-alive connections that were closed
     */    
	public CountStatistic	getCountFlushes();
	
    /** 
        @return Number of requests received by connections in keep-alive mode.
     */    
	public CountStatistic	getCountHits();
}
