/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/util/jmx/Acronyms.java,v 1.1 2006/12/02 06:04:01 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:04:01 $
 */


package com.sun.appserv.management.util.jmx;

import java.util.Map;
import java.util.HashMap;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.util.misc.MapUtil;



/**
 */
public final class Acronyms
{
	private static Map<String,String>	MAP	= null;
	
	private static final String[]	MAPPINGS	= new String[]
	{
		"Cmp", "CMP",
		"CmpContainer", "CMPContainer",
		"Corba", "CORBA",
		"EjbContainer", "EJBContainer",
		"HttpListeners", "HTTPListeners",
		"HttpService", "HTTPService",
		"Jacc", "JACC",
		"Jaxr", "JAXR",
		"Jaxrpc", "JAXRPC",
		"JdbcConnectionPool", "JDBCConnectionPool",
		"JDBCResourceJndiName", "JDBCResourceJNDIName",
		"Jdo", "JDO",
		"Jms", "JMS",
		"JndiName", "JNDIName",
		"Jta", "JTA",
		"Jts", "JTS",
		"JvmOptions", "JVMOptions",
		"MdbContainer", "MDBContainer",
		"Orb", "ORB",
		"RmicOptions", "RMICOptions",
		"Saaj", "SAAJ",
		"Ssl2Ciphers", "SSL2Ciphers",
		"Ssl2Enabled", "SSL2Enabled",
		"Ssl3Enabled", "SSL3Enabled",
		"Ssl3TlsCiphers", "SSL3TLSCiphers",
		"SystemJmxConnectorName", "SystemJMXConnectorName",
		"TlsEnabled", "TLSEnabled",
		"TlsRollbackEnabled", "TLSRollbackEnabled",
		"SfsbPersistenceType", "SFSBPersistenceType",
		"SfsbHaPersistenceType", "SFSBHAPersistenceType",
		"SfsbCheckpointEnabled", "SFSBCheckpointEnabled",
		"SfsbQuickCheckpointEnabled", "SFSBQuickCheckpointEnabled",
		"SfsbStorePoolName", "SFSBStorePoolName",
		"SsoFailoverEnabled", "SSOFailoverEnabled",
		"HttpSessionStorePoolName", "HTTPSessionStorePoolName",
		"DnsLookupEnabled", "DNSLookupEnabled",
		"SslEnabled", "SSLEnabled",
		"ThreadPoolIds", "ThreadPoolIDs",
		"JndiLookupName", "JNDILookupName",
		};
	
	/**
		Return a Map whose keys are acronyms (their case should be ignored),
		and whose values are the proper capitalization.
	 */
		public static synchronized Map<String,String>
	getMap()
	{
		if ( MAP == null )
		{
			MAP	= MapUtil.newMap( MAPPINGS );
		}
		return( MAP );
	}
}

