/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/util/jmx/MBeanProxyHandlerIntf.java,v 1.1 2006/12/02 06:04:06 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:04:06 $
 */

package com.sun.appserv.management.util.jmx;

import java.util.logging.Logger;

import javax.management.ObjectName;
import javax.management.MBeanInfo;

/**
	Documents built-in supported operations of {@link MBeanProxyHandler}.
 */
public interface MBeanProxyHandlerIntf
{
	/**
		Get the MBeanInfo for the MBean this proxy represents.
		
		@return the MBeanInfo or null if not available or inappropriate
	 */
	public MBeanInfo	getMBeanInfo();
	
		
 	public ObjectName 	getTargetObjectName();
 	
	/**
		Set a Logger for this proxy.
		Proxies emit most log messages at FINE, FINER, FINEST levels only.
		@param logger
	 */
	public void	setProxyLogger( Logger logger );
	
	/**
		Get this proxy's Logger (if any)
	 */
	public Logger	getProxyLogger( );
}


