/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/util/jmx/MBeanServerConnectionSource.java,v 1.1 2006/12/02 06:04:07 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:04:07 $
 */

package com.sun.appserv.management.util.jmx;

import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;

import com.sun.appserv.management.client.ConnectionSource;


/**
	A ConnectionSource for in-process access where the MBeanServer is actually
	known and where later access to it may be desired.
 */
public final class MBeanServerConnectionSource implements ConnectionSource
{
	protected MBeanServer		mServer;
	
	/**
		Create a new instance for the specified MBeanServer
	 */
		public
	MBeanServerConnectionSource( final MBeanServer server )
	{
		mServer	= server;
	}
	
	/**
		Return the internal MBeanServer 
	 */
		public MBeanServer
	getMBeanServer( )
	{
		return( mServer );
	}
	
		public MBeanServerConnection
	getExistingMBeanServerConnection( )
	{
		return( getMBeanServer() );
	}
	
		public MBeanServerConnection
	getMBeanServerConnection( boolean forceNew )
	{
		return( getExistingMBeanServerConnection() );
	}
	
	
		public JMXConnector
	getJMXConnector( boolean forceNew )
	{
		// we can't supply one...
		return( null );
	}
}
