/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/appserv-api/src/java/com/sun/appserv/management/util/misc/EnumerationIterator.java,v 1.1 2006/12/02 06:04:28 llc Exp $
 * $Revision: 1.1 $
 * $Date: 2006/12/02 06:04:28 $
 */
package com.sun.appserv.management.util.misc;

import java.util.Iterator;
import java.util.Enumeration;


/**
	Implements the Iterator interface over an Enumeration
 */
public final class EnumerationIterator implements Iterator
{
	private final Enumeration	mEnum;
	
		public
	EnumerationIterator( Enumeration enumIn )
	{
		mEnum	= enumIn;
	}
	
		public boolean
	hasNext()
	{
		return( mEnum.hasMoreElements() );
	}
	
		public Object
	next()
	{
		return( mEnum.nextElement() );
	}
	
		public void
	remove()
	{
		throw new UnsupportedOperationException( "" );
	}
}
