/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.misc;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

public final class IteratorUtil
{
		private
	IteratorUtil( )
	{
		// disallow instantiation
	}
	
	
		public static <T> Object[]
	toArray( final Iterator<T>	iter)
	{
		final List<T> list	= new ArrayList<T>();
		
		while ( iter.hasNext() )
		{
			final T	elem	= iter.next();
			list.add( elem );
		}
		
		final Object[]	result	= new Object[ list.size() ];
		list.toArray( result );
		
		return( ArrayConversion.specializeArray( result ) );
	}
	
    /**
        @param iter 
        @return the Class of the elements, or null if all null or different
     */
		public static Class
	getUniformClass( final Iterator<?> iter)
	{
		Class	theClass	= null;
		
        Object next;
		if ( iter.hasNext() )
		{
            next   = iter.next();
			theClass	= (next == null) ? null : next.getClass();
		}

		while ( iter.hasNext() )
		{
            next    = iter.next();
            
			if ( next != null && next.getClass() != theClass )
			{
				theClass	= null;
				break;
			}
		}
		
		return( theClass );
	}
	
    /**
        @param iter 
        @param theClass
        @param exactMatch  if true, then subclasses are considered to be different
        @return true if all items are of the same class
     */
		public static <T> boolean
	isUniformClass(
		final Iterator<?>	iter,
		final Class<T>      theClass,
		final boolean       exactMatch )
	{
		boolean	isUniform	= true;
		
		while ( iter.hasNext() )
		{
            Object next = iter.next();
			final Class	nextClass	= (next == null) ? null : next.getClass();
			
			if ( nextClass != theClass && nextClass != null )
			{
				if ( exactMatch )
				{
					isUniform	= false;
					break;
				}
				
				if ( ! theClass.isAssignableFrom( nextClass ) )
				{
					isUniform	= false;
					break;
				}
			}
		}
		
		return( isUniform );
	}
}

