/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.misc;


/**
    Central registry of timing values. Not intended for threaded use.
 */
public final class TimingDelta
{
    private long  mLastNanos;
    
        public
    TimingDelta()
    {
        mLastNanos    = System.nanoTime();
    }
    
    /**
        @deprecated use elapsedNanos
     */
        public long
    elapsed()
    {
       return elapsedNanos();
    }
    
        public long
    elapsedNanos()
    {
        final long now = System.nanoTime();
        final long elapsed = now - mLastNanos;
        mLastNanos  = now;
        return elapsed;
    }
    
        public long
    elapsedMicros()
    {
        return elapsed() / 1000;
    }
    
        public long
    elapsedMillis()
    {
        return elapsed() / (1000 * 1000);
    }
}

































