/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.util.stringifier;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;



/**
	Holds a lookup table for Stringifiers.   Certain Stringifier classes
	may use this registry to aid them in producing suitable output.
 */
public class StringifierRegistryImpl implements StringifierRegistry
{
	public static final StringifierRegistry	DEFAULT	= new StringifierRegistryImpl();
	
	private final Map<Class<?>,Stringifier>		mLookup;
	private final StringifierRegistry			mNextRegistry;
	
	/**
		Create a new registry with no next registry.
	 */
		public
	StringifierRegistryImpl()
	{
		this( null );
	}
	
	/**
		Create a new registry which is chained to an existing registry.
		
		When lookup() is called, if it cannot be found in this registry, then
		the chainee is used.
		
		@param registry	the registry to use if this registry fails to find a Stringifier
	 */
		public
	StringifierRegistryImpl( StringifierRegistry registry )
	{
		mLookup			= new HashMap<Class<?>,Stringifier>();
		mNextRegistry	= registry;
	}
	
		public void
	add( Class theClass, Stringifier stringifier )
	{
		if ( lookup( theClass ) != null )
		{
			new Exception().printStackTrace();
		}
		
		mLookup.remove( theClass );
		mLookup.put( theClass, stringifier );
	}
	
	
		public Stringifier
	lookup( Class theClass )
	{
		Stringifier		stringifier	= (Stringifier)mLookup.get( theClass );
		
		if ( stringifier == null && mNextRegistry != null )
		{
			stringifier	= mNextRegistry.lookup( theClass );
		}
		
		return( stringifier );
	}
}



