/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.util.List;
import java.util.LinkedList;

import java.lang.reflect.Method;

public class InjectionInfo {

    private List<InjectionCapable> injectionResources; 

    // Name of post-consturct method.  Set to null if there is no post-construct
    // method for this class.
    private String postConstructMethodName;

    // Cached post-construct reflection object method.  Only
    // set at runtime.
    private Method postConstructMethod;

    // Name of pre-destroy method.  Set to null if there is no pre-destroy
    // method for this class.
    private String preDestroyMethodName;

    // Cached pre-destroy reflection object method.  Only
    // set at runtime.
    private Method preDestroyMethod;

    private String className;

    public InjectionInfo() {
    }

    public InjectionInfo(String cName, String postmName, String premName,
            List<InjectionCapable> resources) {
        className = cName;
        postConstructMethodName = postmName;
        preDestroyMethodName = premName;
        injectionResources = resources;
    }

    public List<InjectionCapable> getInjectionResources() {
        if (injectionResources == null) {
            injectionResources = new LinkedList<InjectionCapable>();
        }
        return injectionResources;
    } 

    public void setInjectionResources(List<InjectionCapable> resources) {
        injectionResources = resources; 
    }

    public String getPostConstructMethodName() {
        return postConstructMethodName;
    }

    public void setPostConstructMethodName(String methodName) {
        postConstructMethodName = methodName;
    }

    public Method getPostConstructMethod() {
        return postConstructMethod;
    }

    public void setPostConstructMethod(Method method) {
        postConstructMethod = method;
    }

    public String getPreDestroyMethodName() {
        return preDestroyMethodName;
    }

    public Method getPreDestroyMethod() {
        return preDestroyMethod;
    }

    public void setPreDestroyMethod(Method method) {
        preDestroyMethod = method;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String name) {
        className = name;
    }
}
