/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.web.MimeMapping;
import java.io.Serializable;

    /*** I represent a mapping between a mime type and a file extension for specifiying how
    * to handle mime types in a J2EE WAR.
    *@author Danny Coward
    */

public class MimeMappingDescriptor implements MimeMapping, Serializable {
    private String extension;
    private String mimeType;
    
    /** copy constructor */
    public MimeMappingDescriptor(MimeMappingDescriptor other) {
	// super(other);
	extension = other.extension;
	mimeType = other.mimeType;
    }

    /** Construct the mapping for the given extension to the given mime type. */
    public MimeMappingDescriptor(String extension, String mimeType) {
	this.extension = extension;
	this.mimeType = mimeType;
    }
    
    /* Default constructor. */
    public MimeMappingDescriptor() {
    }

    /** Return the filename extension for this mapping. */
    public String getExtension() {
	if (this.extension == null) {
	    this.extension = "";
	}
	return this.extension;
    }
    
    /** Set the filename extension for this mapping. */
    public void setExtension(String extension) {
	this.extension = extension;
    }
    
    /** Get the mime type for this mapping. */
    public String getMimeType() {
	if (this.mimeType == null) {
	    this.mimeType = "";
	}
	return this.mimeType;
    }
    /** Set the mime type for this mapping. */
    public void setMimeType(String mimeType) {
	this.mimeType = mimeType;
    }
    /** My pretty format. */
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("MimeMapping: ").append(this.getExtension()).append("@").append(this.getMimeType());
    }

}
