/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import java.util.LinkedList;
import java.util.Iterator;
import java.util.List;

/**
 * Represents a single handler-chains in a webservice in webservices.xml
 */
public class WebServiceHandlerChain extends Descriptor {

    // List of handlers associated with this endpoint. 
    // Handler order is important and must be preserved.
    private LinkedList<WebServiceHandler> handlers;

    private String protocolBinding = null;
    private String serviceNamePattern = null;
    private String portNamePattern = null;
    
    // copy constructor
    public WebServiceHandlerChain(WebServiceHandlerChain other) {
	super(other);
        this.protocolBinding = other.protocolBinding;
        this.serviceNamePattern = other.serviceNamePattern;
        this.portNamePattern = other.portNamePattern;
	if (other.handlers != null) {
            handlers = new LinkedList();
	    for (Iterator i = other.handlers.iterator(); i.hasNext();) {
		WebServiceHandler wsh = (WebServiceHandler)i.next();
		handlers.addLast(new WebServiceHandler(wsh));
	    }
	} else {
	    handlers = null;
	}
    }

    public WebServiceHandlerChain() {
        handlers = new LinkedList();
    }

    public void setProtocolBindings(String bindingId) {
        protocolBinding = bindingId;
        super.changed();
    }
    
    public String getProtocolBindings() {
        return protocolBinding;
    }
    
    public void setServiceNamePattern(String pattern) {
        serviceNamePattern = pattern;
        super.changed();
    }
    
    public String getServiceNamePattern() {
        return serviceNamePattern;
    }
    
    public void setPortNamePattern(String pattern) {
        portNamePattern = pattern;
        super.changed();
    }
    
    public String getPortNamePattern() {
        return portNamePattern;
    }
    
    /**
     *@return true if this endpoint has at least one handler in its
     * handler chain.
     */
    public boolean hasHandlers() {
        return ( handlers.size() > 0 );
    }

    /**
     * Append handler to end of handler chain for this endpoint.
     */
    public void addHandler(WebServiceHandler handler) {
        handlers.addLast(handler);
        super.changed();
    }

    public void removeHandler(WebServiceHandler handler) {
        handlers.remove(handler);
        super.changed();
    }

    public void removeHandlerByName(String handlerName) {
        for(Iterator iter = handlers.iterator(); iter.hasNext();) {
            WebServiceHandler next = (WebServiceHandler) iter.next();
            if( next.getHandlerName().equals(handlerName) ) {
                iter.remove();
                super.changed();
                break;
            }
        }
    }

    /**
     * Get ordered list of WebServiceHandler handlers for this endpoint.
     */
    public List<WebServiceHandler> getHandlers() {
        return handlers;
    }
}
