/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EjbBundleContext.java
 *
 * Created on January 12, 2005, 10:20 AM
 */

package com.sun.enterprise.deployment.annotation.context;

import java.util.List;
import java.util.ArrayList;

import java.lang.annotation.ElementType;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;

/**
 * This ClientContext implementation holds a top level reference
 * to the DOL EJB BundleDescriptor which will be used to populate
 * any information processed from the annotations.
 *
 * @author Jerome Dochez
 */
public class EjbBundleContext extends ResourceContainerContextImpl {
    
    /** Creates a new instance of EjbBundleContext */
    public EjbBundleContext(EjbBundleDescriptor descriptor) {
        super(descriptor);
    }
    
    public EjbBundleDescriptor getDescriptor() {
        return (EjbBundleDescriptor)descriptor;
    }

    /**
     * This methods create a context for Ejb(s) by using descriptor(s)
     * associated to given ejbClassName.
     * Return null if corresponding descriptor is not found.
     */
    public AnnotatedElementHandler createContextForEjb() {
        Class ejbClass = (Class)this.getProcessingContext().getProcessor(
                ).getLastAnnotatedElement(ElementType.TYPE);
        EjbDescriptor[] ejbDescs = null;
        String ejbClassName = null;
        if (ejbClass != null) {
            ejbClassName = ejbClass.getName();
            ejbDescs = this.getDescriptor().getEjbByClassName(ejbClassName);
        }

        AnnotatedElementHandler aeHandler = null;
        if (ejbDescs != null && ejbDescs.length > 1) {
            aeHandler = new EjbsContext(ejbDescs, ejbClass);
        } else if (ejbDescs != null && ejbDescs.length == 1) {
            aeHandler = new EjbContext(ejbDescs[0], ejbClass);
        }

        if (aeHandler != null) {
            // push a EjbContext to stack
            this.getProcessingContext().pushHandler(aeHandler);
        }
        return aeHandler;
    }
            
    public HandlerChainContainer[] 
            getHandlerChainContainers(boolean serviceSideHandlerChain, Class declaringClass) {
        if(serviceSideHandlerChain) {
            EjbDescriptor[] ejbs;
            if(declaringClass.isInterface()) {
                ejbs = getDescriptor().getEjbBySEIName(declaringClass.getName());
            } else {
                ejbs = getDescriptor().getEjbByClassName(declaringClass.getName());
            }
            List<WebServiceEndpoint> result = new ArrayList<WebServiceEndpoint>();
            for (EjbDescriptor ejb : ejbs) {
                result.addAll(getDescriptor().getWebServices().getEndpointsImplementedBy(ejb));
            }
            return(result.toArray(new HandlerChainContainer[0]));
        } else {
            List<ServiceReferenceDescriptor> result = new ArrayList<ServiceReferenceDescriptor>();
            result.addAll(getDescriptor().getServiceReferenceDescriptors());
            return(result.toArray(new HandlerChainContainer[0]));
        }
    }
    
    public ServiceReferenceContainer[] getServiceRefContainers() {
        ServiceReferenceContainer[] container = 
                new ServiceReferenceContainer[getDescriptor().getEjbs().size()];
        ServiceReferenceContainer[] ret = 
                (ServiceReferenceContainer[])getDescriptor().getEjbs().toArray(container);
        return ret;
    }    
    
    /**
     * This methods create a context for EjbInterceptor associated to
     * given className.
     * Return null if corresponding descriptor is not found.
     */
    public AnnotatedElementHandler createContextForEjbInterceptor() {
        Class interceptorClass =
                (Class)this.getProcessingContext().getProcessor(
                ).getLastAnnotatedElement(ElementType.TYPE);
        EjbInterceptor ejbInterceptor =
                this.getDescriptor().getInterceptorByClassName(
                interceptorClass.getName());
        
        AnnotatedElementHandler aeHandler = null;
        if (ejbInterceptor != null) {
            aeHandler = new EjbInterceptorContext(ejbInterceptor);
            // push a EjbInterceptorContext to stack
            this.getProcessingContext().pushHandler(aeHandler);
        }
        return aeHandler;
    }
}
