/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EjbContext.java
 *
 * Created on January 16, 2005, 5:53 PM
 */

package com.sun.enterprise.deployment.annotation.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.AnnotationInfo;
import com.sun.enterprise.deployment.annotation.ProcessingContext;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.annotation.impl.ComponentDefinition;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.util.TypeUtil;

/**
 *
 * @author dochez
 */
public class EjbContext extends ResourceContainerContextImpl {
    private WebServiceEndpoint endpoint;
    private Method[] methods;
    private boolean inherited;
    private ArrayList<PostProcessInfo> postProcessInfos =
            new ArrayList<PostProcessInfo>();

    public EjbContext(EjbDescriptor currentEjb, Class ejbClass) {
        super(currentEjb);
        componentClassName = currentEjb.getEjbClassName();
        ComponentDefinition cdef = new ComponentDefinition(ejbClass);
        methods = cdef.getMethods();
        Class superClass = ejbClass.getSuperclass();
        inherited = (superClass != null && !Object.class.equals(superClass));
    }

    public EjbDescriptor getDescriptor() {
        return (EjbDescriptor)descriptor;
    }

    public void setDescriptor(EjbDescriptor currentEjb) {
        descriptor = currentEjb;
    }

    public void setEndpoint(WebServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }
    
    public WebServiceEndpoint getEndpoint() {
        return endpoint;
    }

    public void endElement(ElementType type, AnnotatedElement element) 
            throws AnnotationProcessorException {
        
        if (ElementType.TYPE.equals(type)) {
            for (PostProcessInfo ppInfo : postProcessInfos) {
                 ppInfo.postProcessor.postProcessAnnotation(
                         ppInfo.ainfo, this);
            }

            // done with processing this class, let's pop this context
            getProcessingContext().popHandler();
        }
    }

    public Class getDeclaringClass(MethodDescriptor md) {
        Method method = md.getMethod(getDescriptor());
        Class declaringClass = null;
        for (Method m : methods) {
            if (TypeUtil.sameMethodSignature(m, method)) {
                declaringClass = m.getDeclaringClass();
            }
        }
        return declaringClass;
    }

    public boolean isInherited() {
        return inherited;
    }

    public void addPostProcessInfo(AnnotationInfo ainfo, PostProcessor postProcessor) {
        PostProcessInfo ppInfo = new PostProcessInfo();
        ppInfo.ainfo = ainfo;
        ppInfo.postProcessor = postProcessor;
        postProcessInfos.add(ppInfo);
    }

    private class PostProcessInfo {
        public AnnotationInfo ainfo;
        public PostProcessor postProcessor;
    }
    
    public ServiceReferenceContainer[] getServiceRefContainers(String implName) {
        return getDescriptor().getEjbBundleDescriptor().getEjbByClassName(implName);
    }    

    public HandlerChainContainer[] 
            getHandlerChainContainers(boolean serviceSideHandlerChain, Class declaringClass) {
        if(serviceSideHandlerChain) {
            EjbDescriptor[] ejbs = getDescriptor().getEjbBundleDescriptor().getEjbByClassName(declaringClass.getName());
            List<WebServiceEndpoint> result = new ArrayList<WebServiceEndpoint>();
            for (EjbDescriptor ejb : ejbs) {
                result.addAll(getDescriptor().getEjbBundleDescriptor().getWebServices().getEndpointsImplementedBy(ejb));
            }
            return(result.toArray(new HandlerChainContainer[0]));
        } else {
            List<ServiceReferenceDescriptor> result = new ArrayList<ServiceReferenceDescriptor>();
            result.addAll(getDescriptor().getEjbBundleDescriptor().getServiceReferenceDescriptors());
            return(result.toArray(new HandlerChainContainer[0]));
        }
    }    
}
