/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.introspection;

import java.util.Set;
import java.util.HashSet;

/**
 * This class contains the following annotation type:
 * javax.ejb.Stateless
 * javax.ejb.Stateful
 * javax.ejb.MessageDriven
 *
 * @author Qingqing Ouyang
 */
public class EjbComponentAnnotationScanner implements CustomAnnotationScanner {

    private Set<String> annotations=null;
    
    /** Creates a new instance of AnnotationScanner */
    public EjbComponentAnnotationScanner() {}
        
    /**
     * Test if the passed constant pool string is a reference to 
     * a Type.TYPE annotation of a J2EE component
     *
     * @String the constant pool info string 
     * @return true if it is a J2EE annotation reference
     */
    public boolean isAnnotation(String value) {
        if (annotations==null) {
            synchronized(EjbComponentAnnotationScanner.class) {
                if (annotations==null)
                   init();
            }
        }
        return annotations.contains(value);
    }
    
    private void init() {
        annotations = new HashSet();
        annotations.add("Ljavax/ejb/Stateless;");
        annotations.add("Ljavax/ejb/Stateful;");
        annotations.add("Ljavax/ejb/MessageDriven;");
    }
}
