/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;

import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;

/**
 * This interface defines APIs to plug new archivists inside the 
 * DOL library. By default, the DOL will use the ArchivistFactory
 * to instanciate new archivists but if a implementation of this 
 * class is registered, the DOL with use that one.
 *
 * @author Jerome Dochez
 */
public interface PluggableArchivists {
    
    /** 
     * @return a new Archivist implementation for the type passed. 
     * Supported types are defined in the application.xml DTD 
     */
    public Archivist getArchivistForType(ModuleType type);
    
    /** 
     * @return a new Archivist implementation for the archive file type
     * Supported J2EE modules are defined in the J2EE platform spec
     */
    public Archivist getArchivistForArchive(File jarFileOrDirectory) throws IOException;
    
    /** 
     * @return a new Archivist implementation for the archive file type
     * Supported J2EE modules are defined in the J2EE platform spec
     */
    public Archivist getArchivistForArchive(String path) throws IOException;
    
    /** 
     * @return a new Archivist implementation for the archive file type
     * Supported J2EE modules are defined in the J2EE platform spec
     */
    public Archivist getArchivistForArchive(AbstractArchive archive) throws IOException;       
    
}
