/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.interfaces;

import java.util.Iterator;
import java.util.Enumeration;
import java.security.Principal;
import java.util.Map;
import com.sun.enterprise.deployment.Role;

/**
 * This interface defines the protocol used by the DOL to access the role
 * mapping information of a J2EE application. This class is implemented by
 * other modules and their instanciation is done through the 
 * SecurityRoleMapperFactory class.
 *
 * @author Jerome Dochez
 */
public interface SecurityRoleMapper {
    
    /**
     * Set the role mapper application name
     * @param the app name
     */ 
    public void setName(String name);
    
    /**
     * @return the role mapper application name
     */ 
    public String getName();    
    
    /**
     * @return an iterator on all the assigned roles
     */
    public Iterator getRoles();
    
    /**
     * @rturns an enumeration of Principals assigned to the given role
     * @param The Role to which the principals are assigned to.
     */
    public Enumeration getUsersAssignedTo(Role r);
    
    
    /**
     * Returns an enumeration of Groups assigned to the given role
     * @param The Role to which the groups are assigned to.
     */
    public Enumeration getGroupsAssignedTo(Role r);
    
    /**
     * Assigns a Principal to the specified role.
     * @param The principal that needs to be assigned to the role.
     * @param The Role the principal is being assigned to.
     */
    public void assignRole(Principal p, Role r);    
    
    /**
     * Remove the given role-principal mapping
     * @param role, Role object
     * @param principal, the principal
     */    
    public void unassignPrincipalFromRole(Role role, Principal principal);
    
    /**
     *  Remove all the role mapping information for this role
     * @param role, the role object
     */
    public void unassignRole(Role role);
    /*
     * @Map a map of roles to the corresponding subjects
     */
    public Map getRoleToSubjectMapping();
}
