/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.IOException;

import java.util.logging.Level;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Node;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;

import com.sun.enterprise.deployment.util.DOLUtils;

/**
 * This class is responsible for producing DOM document instances from
 * the descriptor classes
 *
 * @author  Jerome Dochez
 * @version 
 */
public class J2EEDocumentBuilder {

    /** Creates new J2EEDocumentBuilder */
    public J2EEDocumentBuilder() {
    }

    /** 
     * Creates and Return a new DOM document based on the current 
     * configuration 
     *
     * @return the new DOM Document object
     */
    public static Document newDocument() {
        try {
            DocumentBuilderFactory factory = 
                DocumentBuilderFactory.newInstance();
            
            DocumentBuilder builder = factory.newDocumentBuilder();
            
            DOMImplementation domImplementation = 
                builder.getDOMImplementation();
            
            Document document = builder.newDocument();
            return document;
        } catch (Exception e) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.saxParserError",
                    new Object[] {"JAXP configuration error"});
            e.printStackTrace();
        } 
        return null;
    }    
    
    /** 
     * Return a document containing a result node based 
     * on the given result descriptor.
     */
    public static Document getDocument(Descriptor descriptor, XMLNode node) {
        try {
            Node domNode = node.writeDescriptor(newDocument(), descriptor);
            if (domNode instanceof Document) 
                return (Document) domNode;
            else 
                return domNode.getOwnerDocument();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }    
        
    public static void write (Descriptor descriptor, final RootXMLNode node,  final File resultFile) throws Exception {
        if (node==null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure",
                new Object[] {descriptor, null});
            return;
        }
        if (resultFile.getParent() != null)
            (new File(resultFile.getParent())).mkdirs();
        FileOutputStream out = new FileOutputStream(resultFile);
        write(descriptor, node, out);
        out.close();
    }
    
    public static void write (Descriptor descriptor, final RootXMLNode node,  final OutputStream os) throws Exception {
        Result output = new StreamResult(os);
        write(descriptor, node, output);
    }    

    public static void write (Descriptor descriptor, final RootXMLNode node,  final Result output) 
                                throws Exception {
        if (node==null) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.invalidDescriptorMappingFailure",
                new Object[] {descriptor, null});
            return;
        }
        try {
            Document document = getDocument(descriptor, node);
            Source source = new DOMSource(document);
            TransformerFactory factory =  TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            setTransformerProperties(node, transformer);
            transformer.transform(source, output);
        } catch(Exception e) {
            e.printStackTrace();
            throw e;
        }
    }        
    

    private static void setTransformerProperties (RootXMLNode node, Transformer transformer) {
        if (node.getDocType()!=null) {
            transformer.setOutputProperty(
                OutputKeys.DOCTYPE_PUBLIC, node.getDocType());
            if (node.getSystemID()!=null) {
                transformer.setOutputProperty(
                    OutputKeys.DOCTYPE_SYSTEM, node.getSystemID());
            }
        }            
        transformer.setOutputProperty(OutputKeys.METHOD, "xml");        
        transformer.setOutputProperty(OutputKeys.INDENT, "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
    }  
    
    public static String descriptorToString(Descriptor descriptor, final DeploymentDescriptorFile ddFile) 
                                throws Exception {
        java.io.StringWriter sw = new java.io.StringWriter();
        StreamResult sr = new StreamResult(sw);
	if (descriptor != null) {
	    write(descriptor, ddFile.getRootXMLNode(descriptor), sr);
	}
        return sw.toString();        
    }
}
