/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;

import org.xml.sax.Attributes;
import org.w3c.dom.Node;
import com.sun.enterprise.deployment.Descriptor;

/**
 * This interface defines the protocol associated with all the nodes. An 
 * XML node is responsible for reading the XML file  into a object
 * representation 
 *
 * @author  Jerome Dochez
 * @version 
 */
public interface XMLNode {

    /**
     * notification of the start of an XML element tag in the processed
     * XML source file. 
     * 
     * @param element the XML element type name
     * @param attributes the specified or defaultted attritutes
     */
    public void startElement(XMLElement element, Attributes attributes);
     
    /**
     * sets the value of an XML element
     * 
     * @param element the XML element type name
     * @param value the element value
     */
    public void setElementValue(XMLElement element, String value);
    
    /** 
     * notification of the end of an XML element in the source XML 
     * file. 
     * 
     * @param element the XML element type name
     * @return true if this node is done with the processing of elements 
     * in the processing
     */
    public boolean endElement(XMLElement element); 
    
    /**
     * Return true if the XMLNode is responisble for handling the 
     * XML element
     * 
     * @param element the XML element type name
     * @return true if the node processes this element name
     */
    public boolean handlesElement(XMLElement element);
    
    /**
     * Return the XMLNode implementation respionsible for
     * handling the sub-element of the current node
     * 
     * @param element the XML element type name
     * @return XMLNode implementation responsible for handling
     * the XML tag
     */
    public XMLNode getHandlerFor(XMLElement element);    
    
    /** 
     * @return the parent node for this XMLNode
     */
    public XMLNode getParentNode();     
    
    /**
     * @return the XMLPath for the element name this node 
     * is handling. The XML path can be a absolute or a 
     * relative XMLPath.
     */
    public String getXMLPath();
    
    /** 
     * @return the Descriptor subclass that was populated  by reading
     * the source XML file
     */
    public Object getDescriptor();
    
    /**
     * Add a new descriptor to the current descriptor associated with 
     * this node. This method is usually called by sub XMLNodes 
     * (Returned by getHandlerFor) to add the result of their parsing 
     * to the main descriptor. 
     *
     * @param descriptor the new descriptor to be added to the current
     * descriptor.
     */
    public void addDescriptor(Object descriptor);
    
    /**
     * write the descriptor to an JAXP DOM node and return it
     * 
     * @param parent node in the DOM tree
     * @param descriptor the descriptor to be written
     * @return the JAXP DOM node for this descriptor
     */
    public Node writeDescriptor(Node parent, Descriptor descriptor);
    
    /**
     * notify of a new prefix mapping used from this node
     */
    public void addPrefixMapping(String prefix, String uri);
    
    /**
     * Resolve a QName prefix to its corresponding Namespace URI by
     * searching up node chain starting with the child.
     */
    public String resolvePrefix(XMLElement element, String prefix);
}

