/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.ejb;

import java.util.Map;
import java.util.Map.Entry;
import org.w3c.dom.Node;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ActivationConfigDescriptor;
import com.sun.enterprise.deployment.xml.EjbTagNames;
import com.sun.enterprise.deployment.util.DOLUtils;

/**
 * This class is responsible for hanlding the activation config elements.
 *
 * @author Kenneth Saks
 * @version 
 */
public class ActivationConfigNode extends DeploymentDescriptorNode {

    private ActivationConfigDescriptor descriptor = null;
    private String propertyName = null;

    public ActivationConfigNode() {
        super();
        registerElementHandler(new XMLElement(EjbTagNames.ACTIVATION_CONFIG),
                               ActivationConfigNode.class, 
                               "setActivationConfigDescriptor");
    }

    /**
     * @return the Descriptor subclass that was populated  by reading
     * the source XML file
     */
    public Object getDescriptor() {
        if (descriptor == null) {
            descriptor = (ActivationConfigDescriptor) super.getDescriptor();
        } 
        return descriptor;        
    }                
    
    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {    
        if (EjbTagNames.ACTIVATION_CONFIG_PROPERTY_NAME.equals
            (element.getQName())) {
            propertyName = value;
        } else if(EjbTagNames.ACTIVATION_CONFIG_PROPERTY_VALUE.equals
                  (element.getQName())) {
            EnvironmentProperty prop = 
                new EnvironmentProperty(propertyName, value, "");
            descriptor.getActivationConfig().add(prop);
            propertyName = null;
        }
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, 
                                ActivationConfigDescriptor descriptor) {        

        Node activationConfigNode = null;
        Set activationConfig = descriptor.getActivationConfig();

        // ActionConfig must have at least one ActionConfigProperty
        // and ActionConfigProperty must have a pair of name/value
        // so filter out the entries with blank name or value  
        Set activationConfig2 = new HashSet(); 
        for(Iterator iter = activationConfig.iterator(); iter.hasNext();) {
            EnvironmentProperty next = (EnvironmentProperty) iter.next();
            if ( ! next.getName().trim().equals("") && 
                 ! next.getValue().trim().equals("")) {
                activationConfig2.add(next);
            }
        }

        if( activationConfig2.size() > 0 ) {
            activationConfigNode = 
                appendChild(parent, nodeName);
            writeLocalizedDescriptions(activationConfigNode, descriptor);
            
            for(Iterator iter = activationConfig2.iterator(); iter.hasNext();) {
                Node activationConfigPropertyNode = 
                    appendChild(activationConfigNode, 
                                EjbTagNames.ACTIVATION_CONFIG_PROPERTY);
                EnvironmentProperty next = (EnvironmentProperty) iter.next();
                appendTextChild(activationConfigPropertyNode, 
                                EjbTagNames.ACTIVATION_CONFIG_PROPERTY_NAME, 
                                (String) next.getName());
                appendTextChild(activationConfigPropertyNode,
                                EjbTagNames.ACTIVATION_CONFIG_PROPERTY_VALUE, 
                                (String) next.getValue());
            }                   
        }        
        return activationConfigNode;
    }
}
