/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime;

import java.util.Map;
import java.util.Map.Entry;
import org.w3c.dom.Node;

import java.util.Set;
import java.util.Iterator;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ActivationConfigDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
 * This class is responsible for hanlding the activation config elements.
 *
 * @author Qingqing Ouyang
 * @version 
 */
public class ActivationConfigNode extends DeploymentDescriptorNode {
    
    private ActivationConfigDescriptor descriptor = null;
    private String propertyName = null;
    
    public ActivationConfigNode() {
        super();
        registerElementHandler(
                new XMLElement(RuntimeTagNames.ACTIVATION_CONFIG),
                ActivationConfigNode.class,
                "setRuntimeActivationConfigDescriptor");
    }

    /**
     * @return the Descriptor subclass that was populated  by reading
     * the source XML file
     */
    public Object getDescriptor() {
        if (descriptor == null) {
            descriptor = ((EjbMessageBeanDescriptor) getParentNode().getDescriptor()).getRuntimeActivationConfigDescriptor();
        } 
        return descriptor;        
    }    
        
    /**
     * all sub-implementation of this class can use a dispatch table to 
     * map xml element to method name on the descriptor class for setting 
     * the element value. 
     *  
     * @return the map with the element name as a key, the setter method 
     *         as a value
     */    
    protected Map getDispatchTable() {
        // no need to be synchronized for now
        Map table = super.getDispatchTable();
        return table;
    }
    
    
    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {    
        if (RuntimeTagNames.ACTIVATION_CONFIG_PROPERTY_NAME.equals
                (element.getQName())) {
            propertyName = value;
        } else if(RuntimeTagNames.ACTIVATION_CONFIG_PROPERTY_VALUE.equals
                (element.getQName())) {
            EnvironmentProperty prop = 
                new EnvironmentProperty(propertyName, value, "");
            descriptor.getActivationConfig().add(prop);
            propertyName = null;
        }
        else super.setElementValue(element, value);
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, 
                                ActivationConfigDescriptor descriptor) {        

        Node activationConfigNode = null;
        Set activationConfig = descriptor.getActivationConfig();
        if( activationConfig.size() > 0 ) {
            activationConfigNode = 
                appendChild(parent, nodeName);
            for(Iterator iter = activationConfig.iterator(); iter.hasNext();) {
                Node activationConfigPropertyNode = 
                    appendChild(activationConfigNode, 
                                RuntimeTagNames.ACTIVATION_CONFIG_PROPERTY);
                EnvironmentProperty next = (EnvironmentProperty) iter.next();
                appendTextChild(activationConfigPropertyNode, 
                        RuntimeTagNames.ACTIVATION_CONFIG_PROPERTY_NAME, 
                        (String) next.getName());
                appendTextChild(activationConfigPropertyNode,
                        RuntimeTagNames.ACTIVATION_CONFIG_PROPERTY_VALUE, 
                        (String) next.getValue());
            }
        }
        
        return activationConfigNode;
    }
}
