/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.runtime.JavaWebStartAccessDescriptor;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.xml.TagNames;
import java.util.Map;
import org.w3c.dom.Node;

/**
 *
 * @author tjquinn
 */
public class JavaWebStartAccessNode extends DeploymentDescriptorNode {
    
    protected JavaWebStartAccessDescriptor descriptor;
    
    /** Creates a new instance of JavaWebStartAccessNode */
    public JavaWebStartAccessNode() {
    }
    
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
	if (descriptor==null) {
	    descriptor = new JavaWebStartAccessDescriptor();
            XMLNode parentNode = getParentNode();
            if (parentNode != null && (parentNode instanceof AppClientRuntimeNode)) {
                Object parentDescriptor = parentNode.getDescriptor();
                if (parentDescriptor != null && (parentDescriptor instanceof ApplicationClientDescriptor) ) {
                    ApplicationClientDescriptor acDescriptor = (ApplicationClientDescriptor) parentDescriptor;
                    acDescriptor.setJavaWebStartAccessDescriptor(descriptor);
                }
                
            }
	} 
	return descriptor;
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */
    protected Map getDispatchTable() {
        Map table =  super.getDispatchTable();
        table.put(RuntimeTagNames.CONTEXT_ROOT, "setContextRoot");
        table.put(RuntimeTagNames.ELIGIBLE, "setEligible");
        table.put(RuntimeTagNames.VENDOR, "setVendor");
        return table;
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, JavaWebStartAccessDescriptor descr) {    
	Node accessNode = super.writeDescriptor(parent, nodeName, descr);
        appendTextChild(accessNode, RuntimeTagNames.CONTEXT_ROOT, descr.getContextRoot());
        appendTextChild(accessNode, RuntimeTagNames.ELIGIBLE, Boolean.toString(descr.isEligible()));
        appendTextChild(accessNode, RuntimeTagNames.VENDOR, descr.getVendor());

	return accessNode;
    }    
    
    public static void writeJavaWebStartInfo(Node parent, JavaWebStartAccessDescriptor descr) {
        if (descr != null) {
            JavaWebStartAccessNode newNode = new JavaWebStartAccessNode();
            newNode.writeDescriptor(parent, RuntimeTagNames.JAVA_WEB_START_ACCESS, descr);
        }
    }
}
